#ifdef GL_ES
precision mediump float;

varying float lambert;
varying vec3 specular;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in float lambert;
in vec3 specular;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform vec3 ambient;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
    vec3 diffuse = lambert * tColor.rgb;
    vec3 newSpec = specular * tColor.a;

    fragColor = vec4(diffuse + newSpec + ambient, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
